/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.platform.GlStateManager;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.client.AccessoryRendererErrorCache;
import io.wispforest.accessories.client.MPOATVConstructingVertexConsumer;
import io.wispforest.accessories.client.PostEffectBuffer;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import java.awt.Color;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4720;
import net.minecraft.class_583;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.lwjgl.opengl.GL30;

public class AccessoriesRenderLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private static final PostEffectBuffer BUFFER = new PostEffectBuffer();
    private static final float increment = 0.1f;
    private static Map<String, Float> brightnessMap = new HashMap<String, Float>();
    private static Map<String, Float> opacityMap = new HashMap<String, Float>();
    private static long lastUpdated20th = 0L;

    public AccessoriesRenderLayer(class_3883<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AccessoriesScreenBase screenBase;
        Object object;
        long current20th;
        boolean shouldUpdate;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        float scale = (float)(1.0 + 0.5 * (0.75 + Math.sin((double)System.currentTimeMillis() / 250.0)));
        Boolean renderingLines = AccessoriesScreen.COLLECT_ACCESSORY_POSITIONS.getValue();
        Boolean useCustomerBuffer = AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.getValue();
        if (!renderingLines.booleanValue() && !AccessoriesScreen.NOT_VERY_NICE_POSITIONS.isEmpty()) {
            AccessoriesScreen.NOT_VERY_NICE_POSITIONS.clear();
        }
        if (multiBufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 bufferSource = (class_4597.class_4598)multiBufferSource;
            bufferSource.method_22993();
        }
        boolean bl = shouldUpdate = lastUpdated20th != (current20th = calendar.getTimeInMillis() / 50L);
        if (shouldUpdate) {
            lastUpdated20th = current20th;
        }
        class_437 screen = class_310.method_1551().field_1755;
        AccessoriesInternalSlot selected = null;
        if (screen instanceof AccessoriesScreenBase && (object = (screenBase = (AccessoriesScreenBase)screen).getHoveredSlot()) instanceof AccessoriesInternalSlot) {
            AccessoriesInternalSlot slot;
            selected = slot = (AccessoriesInternalSlot)object;
        }
        AccessoriesConfig.ScreenOptions_.UnHoveredOptions_ unHoveredOptions = Accessories.config().screenOptions.unHoveredOptions;
        AccessoriesConfig.ScreenOptions_.HoveredOptions_ hoveredOptions = Accessories.config().screenOptions.hoveredOptions;
        for (Map.Entry entry : capability.getContainers().entrySet()) {
            AccessoriesContainer container = (AccessoriesContainer)entry.getValue();
            ExpandedSimpleContainer accessories = container.getAccessories();
            ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
            boolean containerSelected = selected != null && selected.accessoriesContainer.slotType() == container.slotType();
            for (int i = 0; i < accessories.method_5439(); ++i) {
                AccessoryRenderer renderer;
                boolean isSelected;
                boolean bl2 = isSelected = containerSelected && selected.method_34266() == i;
                if (shouldUpdate) {
                    Float currentBrightness = brightnessMap.getOrDefault((String)entry.getKey() + i, Float.valueOf(1.0f));
                    Float currentOpacity = opacityMap.getOrDefault((String)entry.getKey() + i, Float.valueOf(1.0f));
                    if (selected != null && !isSelected) {
                        brightnessMap.put((String)entry.getKey() + i, Float.valueOf(Math.max(unHoveredOptions.darkenedBrightness(), currentBrightness.floatValue() - 0.1f)));
                        opacityMap.put((String)entry.getKey() + i, Float.valueOf(Math.max(unHoveredOptions.darkenedOpacity(), currentOpacity.floatValue() - 0.1f)));
                    } else {
                        brightnessMap.put((String)entry.getKey() + i, Float.valueOf(Math.min(1.0f, currentBrightness.floatValue() + 0.1f)));
                        opacityMap.put((String)entry.getKey() + i, Float.valueOf(Math.min(1.0f, currentOpacity.floatValue() + 0.1f)));
                    }
                }
                class_1799 stack = accessories.method_5438(i);
                class_1799 cosmeticStack = cosmetics.method_5438(i);
                if (!cosmeticStack.method_7960() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmeticStack;
                }
                if (stack.method_7960() || (renderer = AccessoriesRendererRegistry.getRenderer(stack)).isEmpty() || !renderer.shouldRender(container.shouldRender(i))) continue;
                poseStack.method_22903();
                MPOATVConstructingVertexConsumer mpoatv = new MPOATVConstructingVertexConsumer();
                MutableBoolean bufferedGrabbedFlag = new MutableBoolean(false);
                class_4597 innerBufferSource = renderType -> {
                    bufferedGrabbedFlag.setValue(true);
                    return useCustomerBuffer != false ? class_4720.method_24037((class_4588)multiBufferSource.getBuffer(renderType), (class_4588)mpoatv) : multiBufferSource.getBuffer(renderType);
                };
                if (!AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.getValue().booleanValue() || isSelected || selected == null || unHoveredOptions.renderUnHovered()) {
                    try {
                        renderer.render(stack, SlotReference.of(entity, container.getSlotName(), i), poseStack, this.method_17165(), innerBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                    }
                    catch (Throwable e) {
                        AccessoryRendererErrorCache.logIfTimeAllotted(entity, stack, renderer, e);
                    }
                }
                float[] colorValues = null;
                if (useCustomerBuffer.booleanValue() && bufferedGrabbedFlag.getValue().booleanValue()) {
                    if (multiBufferSource instanceof class_4597.class_4598) {
                        class_4597.class_4598 bufferSource = (class_4597.class_4598)multiBufferSource;
                        if (hoveredOptions.brightenHovered() && isSelected) {
                            if (calendar.get(2) + 1 == 5 && calendar.get(5) == 16) {
                                float hue = (float)((double)System.currentTimeMillis() / 20.0 % 360.0 / 360.0);
                                Color color = new Color(class_3532.method_15369((float)hue, (float)1.0f, (float)1.0f));
                                colorValues = new float[]{(float)color.getRed() / 128.0f, (float)color.getGreen() / 128.0f, (float)color.getBlue() / 128.0f, 1.0f};
                            } else {
                                float mul = hoveredOptions.cycleBrightness() ? scale : 1.5f;
                                colorValues = new float[]{mul, mul, mul, 1.0f};
                            }
                        } else if (unHoveredOptions.darkenUnHovered()) {
                            Float darkness = brightnessMap.getOrDefault((String)entry.getKey() + i, Float.valueOf(1.0f));
                            colorValues = new float[]{darkness.floatValue(), darkness.floatValue(), darkness.floatValue(), opacityMap.getOrDefault((String)entry.getKey() + i, Float.valueOf(1.0f)).floatValue()};
                        }
                        if (colorValues != null) {
                            BUFFER.beginWrite(true, 256);
                            bufferSource.method_22993();
                            BUFFER.endWrite();
                            BUFFER.draw(colorValues);
                            class_276 frameBuffer = BUFFER.buffer();
                            GlStateManager._glBindFramebuffer((int)36008, (int)frameBuffer.field_1476);
                            GL30.glBlitFramebuffer((int)0, (int)0, (int)frameBuffer.field_1482, (int)frameBuffer.field_1481, (int)0, (int)0, (int)frameBuffer.field_1482, (int)frameBuffer.field_1481, (int)256, (int)9728);
                            class_310.method_1551().method_1522().method_1235(false);
                        } else {
                            bufferSource.method_22993();
                        }
                    }
                    if (renderingLines.booleanValue() && AccessoriesScreen.IS_RENDERING_LINE_TARGET.getValue().booleanValue()) {
                        AccessoriesScreen.NOT_VERY_NICE_POSITIONS.put(container.getSlotName() + i, mpoatv.meanPos());
                    }
                }
                poseStack.method_22909();
            }
        }
    }
}

